#include <iostream>
#include <vector>
#include <queue>
using namespace std;
struct Graph
{
    long long int n;
    vector<vector<long long int> > adj;
    vector<long long int> boja;
};

void init_graph(Graph &g,long long int n)
{
    g.n=n;
    g.adj.resize(n);
    g.boja.resize(n,0);
}

void addEdge(Graph &g,long long int u,long long int v)
{
    g.adj[u].push_back(v);
    g.adj[v].push_back(u);
}
unsigned long long int crveni=0;
unsigned long long int plavi=0;
void BFS(Graph &g)
{
    queue<long long int> q;
    queue<long long int> color;
    q.push(0);
    color.push(1);
    crveni++;
    g.boja[0]=1;
    while(!q.empty())
    {
        long long int pom=q.front();
        long long int pomcol=color.front();
        q.pop();
        color.pop();
        for(long long int i=0;i<g.adj[pom].size();i++)
        {
            if(g.boja[g.adj[pom][i]]==0)
            {
               g.boja[g.adj[pom][i]]=pomcol*(-1);
               q.push(g.adj[pom][i]);
               color.push(pomcol*(-1));
               if(pomcol==1)
               {
                   plavi++;
               }
               else
               {
                   crveni++;
               }
            }

        }

    }



}

int main()
{
    ios_base::sync_with_stdio(false);
    long long int n;
    cin >>n;
    Graph g;
    init_graph(g,n);
    vector<unsigned long long int> v(n);
    for(long long int i=0;i<n;i++)
    {
        cin >>v[i];
    }

    for(long long int i=0;i<n-1;i++)
    {
        long long int u,v;
        cin >>u>>v;
        u--;
        v--;
        addEdge(g,u,v);

    }
    BFS(g);
    if(crveni>plavi)
    {
        cout <<plavi*v[0]<<"\n";
        cout <<plavi<<"\n";
        for(long long int i=0;i<n;i++)
        {
            if(g.boja[i]==-1)
            {
                cout <<i+1<<" ";
            }
        }
        cout <<"\n";
    }
    else
    {
        cout <<crveni*v[0]<<"\n";
        cout <<crveni<<"\n";
        for(long long int i=0;i<n;i++)
        {
            if(g.boja[i]==1)
            {
                cout <<i+1<<" ";
            }
        }
        cout <<"\n";
    }
    cout <<0<<"\n";
    return 0;
}